"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolvePattern = resolvePattern;
const error_1 = require("./error");
function resolvePattern(pattern) {
    switch (pattern.type) {
        case "Identifier":
            return pattern.value;
        case "ObjectPattern":
            return pattern.properties.flatMap(prop => {
                switch (prop.type) {
                    case "AssignmentPatternProperty":
                        return prop.key.value;
                    case "RestElement":
                        return resolvePattern(prop.argument);
                    case "KeyValuePatternProperty":
                        return resolvePattern(prop.value);
                }
            });
        case "ArrayPattern":
            return pattern.elements
                .filter(elem => elem)
                .flatMap(elem => {
                if (elem.type === "RestElement") {
                    return resolvePattern(elem.argument);
                }
                return resolvePattern(elem);
            });
        case "AssignmentPattern":
            return resolvePattern(pattern.left);
        /* istanbul ignore next */
        default:
            (0, error_1.raiseUnexpectedNode)("pattern in variable declaration", pattern.type);
    }
}
