import { AnyActorLogic, EventFromLogic, InputFrom, SnapshotFrom } from "./types.js";
/** @deprecated Use `initialTransition(…)` instead. */
export declare function getInitialSnapshot<T extends AnyActorLogic>(actorLogic: T, ...[input]: undefined extends InputFrom<T> ? [input?: InputFrom<T>] : [input: InputFrom<T>]): SnapshotFrom<T>;
/**
 * Determines the next snapshot for the given `actorLogic` based on the given
 * `snapshot` and `event`.
 *
 * If the `snapshot` is `undefined`, the initial snapshot of the `actorLogic` is
 * used.
 *
 * @deprecated Use `transition(…)` instead.
 * @example
 *
 * ```ts
 * import { getNextSnapshot } from 'xstate';
 * import { trafficLightMachine } from './trafficLightMachine.ts';
 *
 * const nextSnapshot = getNextSnapshot(
 *   trafficLightMachine, // actor logic
 *   undefined, // snapshot (or initial state if undefined)
 *   { type: 'TIMER' }
 * ); // event object
 *
 * console.log(nextSnapshot.value);
 * // => 'yellow'
 *
 * const nextSnapshot2 = getNextSnapshot(
 *   trafficLightMachine, // actor logic
 *   nextSnapshot, // snapshot
 *   { type: 'TIMER' }
 * ); // event object
 *
 * console.log(nextSnapshot2.value);
 * // =>'red'
 * ```
 */
export declare function getNextSnapshot<T extends AnyActorLogic>(actorLogic: T, snapshot: SnapshotFrom<T>, event: EventFromLogic<T>): SnapshotFrom<T>;
