---
title: Bundles
description: 
published: true
date: 2025-08-10T09:00:00.000Z
tags: 
editor: markdown
dateCreated: 2025-08-10T09:00:00.000Z
---

A bunch of our daily experience on our processing machines
is managed by online browsers;
these commonly run packages of code that they demand on-the-go
from relays positioned across the globe.

This is probably the single most compelling mechanism
of modern human communication,
and the idea is so simple and reliable
that we've come up with many incredibly nuanced
modes of description for the phenomenon. 

To begin, the packages of code that are handled by your browser app,
are composed of a few languages operating in harmony;

* `.html`: hyper-text markup language
* `.css`: cascading style sheets
* `.js`: java-script

These have been around for years,
to the degree that if someone who has never opened a code editor
happens across a broken web page,
they are likely to be able to say which of these three languages
the error has occurred in.

Although the boundaries among these languages
are becoming uncommonly blurred,
mainly because of the promiscuous dalliances of `.js`
in the business of the others,
there seems to be a baseline recognition
of the purpose each one promises to uphold.

- - -

To speak more of these blurred bounds;
the three languages are normally passed from a relay
to a consumer's machine
in seemingly a single moment,
and to keep this exchange as quick as possible,
millions of engineering hours are poured
into a problem space called "bundling".

A quick index of the different bundlers through the years;
because they more or less accomplish the same aim,
and are designed to be unseen and unheard,
they become remarkably interchangeable
until one of them fails to keep up with the pace of change.

* [Grunt](https://gruntjs.com)
* [Gulp](https://gulpjs.com)
* [Rollup](https://rollupjs.org)
* [Parcel](https://parceljs.org)
* [Esbuild](http://esbuild.github.io)
* [Vite](http://vitejs.dev)
* [Deno bundle](https://docs.deno.com/runtime/reference/bundling/)

To dramatically complicate the scene,
this cambrian explosion is echoed on the opposing side
of a coder's experience:
how to manage the dependencies of a code base,
that one's app needs to rely upon,
and that are bundled up alongside the bespoke code in each app.

This problem is called "package management",
and for the web space the canonical package index
is [npmjs.com](https://www.npmjs.com/).
The process of sourcing and arranging your dependency packages
can be managed by numerous programs also, such as:

* [npm](https://www.npmjs.com/package/npm) - node package manager
* [bun](https://bun.sh)
* [deno](https://deno.com)
* [yarn](https://yarnpkg.com)

Yikes, oh no.

Finally, there is one more layer of choice
that a coder needs to make:

The bundling process, from beginning to end,
is all managed using JavaScript,
although the more dedicated engineers among us
have learned to build the core machinery in a
quicker and more reliable language,
usually [Rust](https://rust-lang.org)

Now, all of this code we chose to depend on needs to run somehow,
and JavaScript is considered to be rather loose around the edges.
Rather than a single simple engine to run this programming language,
the language is being pulled in many different directions,
because in essence each browser has a company of people behind the scenes,
building new ideas into their own javascript-running engines,
to get the lead compared to their competition
in market niches like mobile phones or media streaming.

So, again in a gradually changing landscape,
these execución engines are:

* [Node.js®](https://nodejs.org/en)
  * based on [v8](https://v8.dev)
* [bun](https://bun.sh)
* [deno](https://deno.com)
* [wasmtime](https://wasmtime.dev) - for special cases.

Having said all this,
I can proceed to make a choice among the options
that I may be happy to build upon for years to come,
and that I may be equally happy to recommend to my peers.

- - -

`Node.js®` (`node`) had been the original engine in the bundling space,
and prior to its release the JavaScript language had only really been used
in web browsers. This becomes clear by examining `v8`,
which had been running in the Chromium code bases long before
being repackaged into `node`.

Although basically enabled the bundling scene in the olden days,
`node` seems to be lagging behind especially in the package manager space.

The included `node` package manager, `npm`,
began to see doppelgangers appear years ago,
such as `yarn`, which promised to be more secure and speedier,
with additional debugging features for thorny issues.
This promise played out as planned,
and `yarn` is as ubiquitous as any choice these days.

I used `yarn` for long enough without looking deeply at the code,
and I essentially assumed that the piece would also be replaced someday,
especially as `rust` libraries became more popular.
Sure enough, `bun` took a huge leap ahead,
and replaced both the package manager and the engine in one go.

For a while I had no need to make a change,
until I began a more serious examinación of [local-first] apps.
Suddenly, the bundler problem was **the problem**, numero uno.

[local-first]: https://www.inkandswitch.com/local-first-software/

I eagerly applied `bun` to my peculiar mix of [build codes](/gram/build),
and although the package manager was running splendidly,
I was able to make no progress on the bundling problem -
for a scary span of time. Months. Seasons.
I could build, but I kept feeling things break in ambiguous directions,
and it was only this morning that I finally pinned down the location
of the problem, in the middle of this mess.

You see, coders have no patience;
we know that our full career is a race,
both against our younger leaner competition
who are spoiled with more graphics cards,
and against the carpal tunnel syndrome we incur,
and beckon on with each keypress.

The bundlers we use to build and ship our online apps
decided to help here,
and they came up with an idea called `hot module reloading`.
In essence, the bundler realizes that to make an app,
a coder needs to see what they are making -
and the bundler is standing directly in the path
from code to rendered page.

It is only good manners, then, to help open the doors in the corridor;
on each file change that a coder makes in their editor,
the bundler is commissioned to sense the change and reload the browser.

In essence,
this reduces the price of making each change by nearly 6 key-presses:

* `[cmd-tab]` to change to the browser
* `[cmd-r]` to reload the page
* `[cmd-tab]` to regress to the editor

When recording a file change requires two key-presses,
a coder can measure this as 75% savings,
on a procedure that needs to happen hundreds of times a day.
Beyond silly numerical measurements,
this is the kind of change that **makes people happier**,
in their employment, and ensures that they can keep their precious focus
on the problem they are hired to do.

If you'd like to discuss burnout and demoralización
among open-source coders, drop a reply.
There's an endless discussion that needs to be unleashed.

- - -

So how did I reach my burnout phase for bundling?

I realize this is a core piece of the program I need to build;
to run locally, an app needs to be bundled for local consumption,
and there is no way of escaping the reliance on a bundler these days.
[Even good desktop apps](https://tauri.app/) are based on this process.

But I had no confidence in the bundlers I chose -
and the problem was hidden from me.

Everyone raved about the bundler [Vite](https://vitejs.dev),
saying things were good to go out of the box,
and there was no end to what you could do.

In practice, I could not even get the page to reload consistently.

* I could bundle the code, and see the rendered page.
* I could make a change in the code, and the page would reload.
* Any additional changes to the code were ignored.
  * Even a manual browser reload ignored the changes
  * I had to re-start the bundler command to pick up any changes.

I sensibly assumed the problem was the bundler,
and looked through the dependency -
[chokidar](https://github.com/paulmillr/chokidar).

Being based on [NixOS](https://nixos.org/) does mean
that occasionally things like this break,
but that was odd to me - I had gone through this before,
which is why I now include the `inotify-tools` package
as a dependency in each of my `flake.nix` files.

Besides, the first page-reload does imply
that `chokidar` sees the change. Infuriating.

A few months ago I traced out the course of this issue,
and realized I was trying about eight options in parallel,
without reliably tracking my methods.

This round, I began to add rigor using `git` branches:

```
* 3f65b69 [bun] rearrange dependencies.  (HEAD -> marko-manual)
* 95f0047 [marko] manual setup using v6 docs.
| * 9610601 [esbuild] begin adding bun commands.  (esbuild)
| * 5b88e2b [esbuild] manage `esbuild` using nix.
|/
| * 9be1bae [vite] dead-end using `vite_phoenix` and `lit`.  (vite)
| * 8645b56 [vite] add `vite_phoenix` hex pkg.
|/
* 5d4c6d9 [bun] add `bun`, manage libs using nix.  (base/main, marko-a, marko, main, lit)
| * cfd6339 [marko] reach a dead-end based on numerous guides.  (base/inert-marko, inert-marko)
| * b130e92 [inertia] clean up rough edges.
| * 7e5f9c6 [tailwind] use nix-managed `tailwindcss_4`.
| * 8ffe251 [bun] use nix-managed `bun` binary.
| * c00ff15 [inertia] copy in nordbeam/exinertia-templates
| * cec3f19 [inertia] igniter.install exinertia, #3
| * 1e6633d [inertia] igniter.install exinertia, #2
| * 18662cd [inertia] igniter.install exinertia, #1
|/
* 14747ff [nix] add `flake.nix` & `flake.lock`
* 07d71f3 [base]> nsh elixir mix phx.new operable
```

After a full day of this I was angry and sad and depressed again.
This is a damn easy, "step #1" kind of problem for many people.
On top of my [money problems],
the only amusement I could find as I cried to sleep in the rolling boat
was to imagine the experience of sinking, tied to an anchor.

[money problems]: https://operand.online/chronicle/charges.due

The silicon machines I am beholden to are made from crystallized sand,
and I am fond of saying that on many days,
composing in this landscape feels like building a house on quicksand.

Luckily, as Shakespeare describes in "The Tempest",

> We are such stuff as dreams are made on,
> and our little life is rounded with a sleep.

At risk of misinterpretation,
my little (sub-microscopic) problems were indeed rounded out
by refreshing my memory in dreams.

When I rose this morning I plunged once more into the quick-sand-scape,
and picked through each thread I had arranged out the day before.
Then I recalled a small conclusion I had reached months ago,
and failed to record in my exhaustion at the time.

> Changing back to `yarn` and `node` repairs `HMR` using `vite` on `nixos`.

If only I had found this phrase somewhere online,
or in the responses of some desparate GPT bot chat,
I'd be holding on a small measure of hope today.

I know that nobody reads these blogs
for the emotional dialogue included,
because I also search, find the clue I need,
and close the page.

I record my mood mainly for a reminder of the pains
when no such clue exists online,
and days can be spent spinning in circles on anchor,
hoping for some manner of release from the silent building anger.

Bun, fix your shit.

Maybe I'll have more fun riding a `deno`saur.
