version = '0.21.3'

local home = os.getenv("HOME")
package.path =
  home .. "/.config/xplr/plugins/?/init.lua;"
  .. home .. "/.config/xplr/plugins/?.lua;"
  .. package.path

-- Type `M` to switch to single map mode.
-- Then press `tab` to switch between single and multi map modes.
-- Press `ctrl-o` to edit the command using your editor.
require("map").setup()

xplr.config.modes.builtin.default.key_bindings.on_key.enter = {
  help = "change",
  messages = {
    {
      BashExec = [===[
        SELECTION=$(cat "${XPLR_PIPE_SELECTION_OUT:?}")
        NODES=${SELECTION:-$XPLR_FOCUS_PATH}
        if [ "$NODES" ]; then
          echo "$NODES" | xargs hx
        fi
     ]===],
    },
  },
}

xplr.config.modes.builtin.default.key_bindings.on_key.R = {
  help = "batch rename",
  messages = {
    {
      BashExec = [===[
       SELECTION=$(cat "${XPLR_PIPE_SELECTION_OUT:?}")
       NODES=${SELECTION:-$(cat "${XPLR_PIPE_DIRECTORY_NODES_OUT:?}")}
       if [ "$NODES" ]; then
         echo -e "$NODES" | nix-shell -p pipe-rename --command renamer
         "$XPLR" -m ExplorePwdAsync
       fi
     ]===],
    },
  },
}

-- xplr.config.modes.builtin.default.key_bindings.on_key.S = {
--   help = "share $PWD",
--   messages = {
--     {
--       BashExec0 = [===[
--         IP=$(ip addr | grep -w inet | cut -d/ -f1 | grep -Eo '[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}' | nix-shell -p fzf --command 'fzf --prompt "Select IP > "')
--         echo "IP: ${IP:?}"
--         read -p "Port (default 5000): " PORT
--         echo
--         nix-shell -p miniserve --command "miniserve --interfaces ${IP:?} --port ${PORT:-5000} -H . -z -g" &
--         sleep 1 && read -p '[press enter to exit]'
--         kill -9 %1
--       ]===],
--     },
--   },
-- }

xplr.config.modes.builtin.default.key_bindings.on_key.P = {
  help = "display graphically",
  messages = {
    {
      BashExecSilently = [===[
        SELECTION=$(cat "${XPLR_PIPE_SELECTION_OUT:?}")
        NODES=${SELECTION:-$XPLR_FOCUS_PATH}
        if [ "$NODES" ]; then
          imv $NODES &
        fi
      ]===],
    },
  },
}

xplr.config.modes.builtin.default.key_bindings.on_key.T = {
  help = "tere nav",
  messages = {
    { BashExec0 = [[
    tere() {
      local result=$(command tere "$@")
      [ -n "$result" ] && cd -- "$result"
    }
    "$XPLR" -m 'ChangeDirectory: %q' "$(nix-shell -p tere --command tere)"
    ]] },
  },
}

local function stat(node)
  return xplr.util.to_yaml(xplr.util.node(node.absolute_path))
end

local function read(path, height)
  local p = io.open(path)

  if p == nil then
    return nil
  end

  local i = 0
  local res = ""
  for line in p:lines() do
    if line:match("[^ -~\n\t]") then
      p:close()
      return
    end

    res = res .. line .. "\n"
    if i == height then
      break
    end
    i = i + 1
  end
  p:close()

  return res
end

xplr.fn.custom.preview_pane = {}
xplr.fn.custom.preview_pane.render = function(ctx)
  local title = nil
  local body = ""
  local n = ctx.app.focused_node
  if n and n.canonical then
    n = n.canonical
  end

  if n then
    title = { format = n.absolute_path, style = xplr.util.lscolor(n.absolute_path) }
    if n.is_file then
      body = read(n.absolute_path, ctx.layout_size.height) or stat(n)
    else
      body = stat(n)
    end
  end

  return { CustomParagraph = { ui = { title = title }, body = body } }
end

local preview_pane = { Dynamic = "custom.preview_pane.render" }
local split_preview = {
  Horizontal = {
    config = {
      constraints = {
        { Percentage = 60 },
        { Percentage = 40 },
      },
    },
    splits = { "Table", preview_pane },
  },
}

xplr.config.layouts.builtin.default =
    xplr.config.layouts.builtin.no_help_no_selection
    -- xplr.util.layout_replace(xplr.config.layouts.builtin.default, "Table", split_preview)
