#!/bin/bash

# use as in:
# > bash <(wget https://share.operand.online/gram/build/prepare/launch.linux.sh -O -) access processor 10.0.0.2 10.0.0.1

# in such case:
# - access is a username
# - processor is your machine's name
# - 10.0.0.2 is your machine's address
# - 10.0.0.1 is the router hub address

set -e # end run on any error.

login_name=${1:-access}
machine_name=$2
machine_address=$3
bridge=$4

lineage() { hostnamectl | grep 'Operating System'; }

enroll() {
  passcode="$(openssl rand -hex 48)"
  echo "$1=$passcode" >> ~/.access
  useradd $1 -d /home/$1 -m -p "$passcode"
  adduser $1 sudo
}

source_as() {
  if [ $(whoami) = "$1" ]; then
    bash <(wget https://share.operand.online/gram/build/$2 -O -) ${@:4}
  else
    if ! id "$1" > /dev/null 2>&1; then
      echo "Enrolling user '$1'"
      enroll $1
    fi
    su -P - $1 -c bash <(wget https://share.operand.online/gram/build/$2 -O -) ${@:4}
  fi
}

name_machine() { if [ ! -z "$machine_name" ]; then
  echo "Naming machine: ${machine_name}"
  if [ $(uname) == "Darwin" ]; then scutil --set HostName "$machine_name"; fi
  if [ $(uname) == "Linux" ]; then hostnamectl set-hostname "$machine_name"; fi
fi; }

signal_address() { if (
  [ -f /etc/network/interfaces ] &
  $(! grep -Fq gateway "/etc/network/interfaces")
); then
  echo "Assigning address: '$machine_address'"
  sed '/eth0/d' -i /etc/network/interfaces
  cat << END >> "/etc/network/interfaces"

auto eth0
iface eth0 inet static
  address $machine_address
  netmask 255.255.255.0
  gateway $bridge
END
  systemctl restart networking
fi; }

echo "Lineage: '$(lineage)'"

if (
  [ $(uname) == "Linux" ] &
  [ $(whoami) = "root" ]
); then
  name_machine
  signal_address

  if lineage | grep -q Fedora; then source_as root line/fedora.sh; fi
  if $(lineage | grep -q Ubuntu) || $(lineage | grep -q Debian); then source_as root line/debian.sh; fi
fi

# See http://brew.sh
if [ $(uname) == "Darwin" ]; then
  echo "You're munching apple; could use some brew."
  [ -d /usr/local/bin/brew ] || (wget https://raw.githubusercontent.com/Homebrew/install/master/install.sh -O - | bash)
  brew update
  brew install git
fi

# source_as root program/radio.sh
# source_as root program/cosmographia.sh
source_as root program/snap.sh || echo "Errors adding any snaps."
source_as $login_name proceed.sh
source_as $login_name proceed.sh
echo
echo "Login as:"
cat ~/.access
