# cosmographia;
# see https://naif.jpl.nasa.gov/naif/cosmographia_components.html

grade=4.2

if [ ! -d ~/src/cosmographia-$grade ]; then
  mkdir -p ~/src
  cd ~/src

  if [ ! -f cosmo-installer-$grade-linux ]; then
    wget https://naif.jpl.nasa.gov/pub/naif/cosmographia/packages/cosmo-installer-$grade-linux
  fi

  chmod +x cosmo-installer-$grade-linux
  ./cosmo-installer-$grade-linux install --da
  mv ~/cosmographia-$grade ~/src/cosmographia-$grade
fi

mkdir -p ~/bin
cat <<END > ~/bin/cosmo
#!/bin/sh
~/src/cosmographia-$grade/Cosmographia.sh
END
chmod +x ~/bin/cosmo
