source ./day.nu

def "cam channel" [channel: int] { $"av://v4l2:/dev/video($channel)" }
def "cam mirror"  [channel: int] { $"/dev/video($channel)" | path expand }

# cam align (cam mirror 0) ...(cam shape blob)
def "cam shape blob" [] { [-vcodec rawvideo -pix_fmt yuv422p] }

# cam screen $cameras.chassis
let cameras = { chassis: (cam channel 2), }

# cam screen (cam chassis)
def cam [name: cell-path] { $cameras | get $name }

def --wrapped "cam align" [channel: int = 0, ...call] {
  nix-shell -p ffmpeg gphoto2 --run ([
    'gphoto2 --stdout --capture-movie'
     $"ffmpeg -i - ($call | str join ' ') -f v4l2 (cam mirror $channel)"
  ] | str join ' | ')
}

def "cam screen" [channel: int = 0] {(
  nsh mpv $"mpv (cam channel $channel)
  --profile=low-latency --untimed
  --stream-record=($env.HOME)/space/rec/(mon)/camera.(day).(cloc).mkv"
)}

# much obliged: https://superuser.com/questions/934984/how-can-i-scale-an-overlay-within-an-ffmpeg-filtercomplex
def "cam label" [ --logo (-l): path ] {
  ls | where name =~ "(JPG|MP4|jpg|mp4|JPEG|jpeg|mkv)$" |
  where {|n| not (($n | get name) =~ 'labeled') } | get name | path parse | each {|node|
    let name = $"($node | get stem).($node | get extension)";
    let size = ffprobe -v quiet -show_entries stream=width,height -of default=noprint_wrappers=1 $name | lines | split column '=' | get column2
    let operands = [
      # "[1][0] scale=oh*mdar:ih/6 [label][source]",
      # "[2][source] scale=oh*mdar:ih/18 [address][source]",
      # "[source][label] overlay=overlay_w/3:main_h-overlay_h-(overlay_w/3)",
      # "[source][label] overlay=main_w-overlay_w-(overlay_h):main_h-(overlay_h*2)",
      # "[source][label] overlay=main_w*0.3:main_h*0.3",
      "[0]overlay=x=0:y=0[out]"
    ] | str join "; \n"
    ffmpeg -i $name -i $logo -b:v 1M -filter_complex $operands -map "[out]" -map 0:a? $"($node | get stem).labeled.($node | get extension)"
  } }

# many messed up pipelines...
# ffmpeg -i $name -i ../label.png -b:v 1M -filter_complex "[1][0] scale=oh*mdar:ih/6 [label][source], [source][label] overlay=overlay_w/2:main_h-(overlay_h*1.5)"  $"($node | get stem).labeled.($node | get extension)"
# ffmpeg -i $name -i ../label.png -b:v 1M -filter_complex "[1][0] scale=oh*mdar:ih/6 [label][source], [source][label] overlay=overlay_w/2:main_h-(overlay_h*1.5)"  $"($node | get stem).marked.($node | get extension)"
# ffmpeg -i $name -i ../label.png -b:v 1M -filter_complex "[1:v]scale=320:320 [label], [0:v][label]overlay=(main_w-overlay_w)/2:(main_h-overlay_h)/2"  $"($node | get stem).labeled.($node | get extension)"
# ffmpeg -i $name -vf $"movie=../label.png [label]; [in][label]  scale=($size | get 0)$*0.15:-1 [out]" $"($node | get stem).labeled.($node | get extension)"
# ffmpeg -i $name -vf "movie=../label.png [label]; [1:v]scale=320:240 [label],[0:v][label] [in][label] overlay=10:main_h-overlay_h-10 [in][label] [out]" $"($node | get stem).labeled.($node | get extension)"
# ffmpeg -i $name -vf "movie=../label.png [label]; [in][label] 10:main_h-overlay_h-10 [in][label] [out]" $"($node | get stem).labeled.($node | get extension)"
