source "./day.nu"
def charge [charge?: string] { if ($charge | is-empty) { nsh acpi acpi -b } else { $charge } }

def "charge plug" [charge?: string] {
  ((charge $charge | split column ',' | get column3.0) | str trim | split column ' ' --number 2 | get column2
  ).0 == 'until charged'
}

def "charge remain" [charge?: string] { dura parse (
  (charge $charge | split column ',' | get column3.0) |
    str trim | split column ' ' --number 2 | get column1.0) | print
  cat /sys/class/power_supply/BAT1/capacity | print
}

# def "charge danger" [dura: duration] { let charge = charge
#   if (charge plug $charge) { 0 } else { $dura / (charge remain $charge) } }

def "charge alarm" [] { let dura = 30min; let charge = charge;
  if not (charge plug $charge) and ($dura > (charge remain $charge)) {
    notify-send $"AH! Under ($dura | into string) of energy!\nPlug plug plug."
} } # if (charge danger $dura) > 1.0 { notify-send "AH! Under 30 mins of energy!\nPlug plug plug."}
