def "clock sync" [] { nsh ntp sudo ntpdate time.nist.gov }
def clock [] { let c = cloq; $"($c.day)_($c.cloc)_z($c.zone)" }
def cloq [] {
  run-external date '-Is' |
  parse '{day}T{cloc}-{zone}' |
  update cells -c [ cloc zone ] { $in | str replace -a -r ':' '-' } |
  into record }
def cloc [] { (cloq).cloc | str replace -a ':' '-' }

def dura [...command: string] { let cl = (clock); echo ($cl); time ...$command; echo; echo ($cl); clock; }

# parse durations, as in:
# 04:44:44 -> 04hr 44min 44sec
def "dura parse" [phrase: string] {
  (($phrase | str replace ':' 'hr ' | str replace ':' 'min ') + 'sec') | into duration
}

def day [label?: cell-path] {
  if ($label | is-empty) { date now } else { get $label } |
  format date "%Y-%m-%d" }

def "day change" [cloc: string] {
  sudo date -s ($cloc | str replace '.' ' ' | into datetime | format date "%D %H:%M")
}

def mon [label?: string] {
  if ($label | is-empty) { date now } else { get $label } |
  format date "%Y-%m" }

def year [] {
  cal --full-year 2024 --week-start mo --month -t
  | group-by month
  | transpose month days
  | each { upsert days { $in | reject month } }
  | get days
}
