#!/usr/bin/env nu

source ~/.config/nushell/nix.nu
source ~/.config/nushell/grammar.nu

def "diagram prelude" [] { '
# --------------------

style.fill: "transparent"

classes: {
  done: {
    style: {
      fill: MediumAquamarine;
      stroke-width: 4;
    }
  }

  progress: {
    style: {
      fill: orange;
      stroke-width: 4;
    }
  }

  aim: {
    style: {
      fill: pink
      shadow: true
    }
  }

  deploy: {
    shape: step
    style.fill: cyan
  }

  long: {
    style.fill: gold
  }

  broken: {
    shape: step
    style.fill: red
  }

  ready: {
    style: {
      stroke: green;
      stroke-width: 8
    }
  }

  bridge: {
    style: {
      stroke: purple
      stroke-width: 4
    }
  }
}

style.fill: "transparent";
(* -> *)[*]: { class: bridge }
' }

def "diagram" [place: string, ...labels: string] {
  mkdir ([share $place] | path join | path dirname)
  try { rm ([ $place _.d2 ] | path join) }
  let l = $labels |
    replace ($labels | is-empty) {
    glob ([$place *.d2 ] | path join) | path parse | get stem }

  $l | each {|name|
    diagram prelude | save -f ([$place _.d2 ] | path join)
    open $"($place)/($name).d2" | save -a ([$place _.d2] | path join)

    let done = [share $place $"($name).svg" ] | path join
    nsh d2 d2 -l elk -t 8 ([ $place _.d2 ] | path join) $done | print
    $done
  } |
  str join "\n" |
  tee { try { rm ([$place _.d2 ] | path join) } }
}
