source ./page.nu

def "map group" [label: string, --domain: string = openstreetmap.org] {
  let marks = (pages | where addr =~ $domain).n | each {
    [$in body.html] | path join | open -r | pup 'a.set_position json{}' | from json
  } | flatten
  $marks | save ($"~/map/($label).yml" | path expand)
  $marks | select data-prefix text href data-id data-lat data-lon
}

# let pages = (open map/marina.baltimore.yml).href |
#   each {|p| [ 'https://openstreetmap.org' $p ] | str join '' } |
#   par-each {http get $in}

# let summary = $pages | each { pup 'h2 text{}' } |
#   str replace -a "\n" '' | split column --regex '[:\(\)]' mark name key
# $summary | save ($"~/map/($label).summary.yml" | path expand)
