def --wrapped l [...call] {
  if ($call | is-empty) { ls } else { ls ...($call) } |
  upsert name { $in | path basename } }

def --env mkcd [node?: path]: path -> nothing {
  let place = $in | path expand;
  mkdir $place; cd $place }

def --env go [node: path] {
  if !($node | path exists) { mkdir $node }; cd $node }

def aim [command: string] { ls -l ...(which $command | get path) | get target }
def --env build [] { go ~/.build }

def nodes [] { tree -afFix --noreport . }

def index [label?: string, --quick (-q)] {
  if ($quick) {
    ls | each { |n| tree -dafix ($n | get name) } |
    str join "\n\n---\n" | lines | less
    esc }

  let c = clock | str trim
  let label = if ($label | is-empty) { pwd | path basename } else { $label }

  tree -dafix | save $"($c).($label).dirname.index"

  let nodes = tree -afix | lines | where { path exists } |
  par-each {|n| ls -Dal $n | where type == "file" } | flatten | uniq

  let basenames = $nodes | get name | save $"($c).($label).basename.index"

  $nodes | to csv | save $"($c).($label).node.ls.index.csv"

  let checks = (ls *.index* | where name =~ $"^($c).") | get name |
  par-each { |n| [ ($n) ($n | hash md5) ($n | hash sha256) ] | into record } |
  rename "node" "md5" "sha256"

  let check = $checks | to csv
  let md5 = $check | hash md5
  let sha256 = $check | hash sha256
  let checknode = $"($c).md5-($md5).sha256-($sha256).index.check"

  $check | save $checknode
  $checks | insert 0 { 'node': $checknode, 'md5': $md5, 'sha256': $sha256 }
  $checks
}
