source ./scan.nu

def page [label?: string, --all (-a), --open (-o)] {
  if $open { return ([~ tabfs fs mnt tabs last-focused] | path join | path expand) }

  let pages = glob $"~/tabfs/fs/mnt/tabs/by-title/*" | each { path basename }
  let pages = if not ($label | is-empty) { $pages | where { $in =~ $label } }

  if $all {
    $pages | each {|p| [ ~/tabfs/fs/mnt/tabs/by-title $p ] | path join | path expand }
  } else {
    [ ~/tabfs/fs/mnt/tabs/by-title ($pages | choose) ] | path join | path expand
} }

def "page addr" [label?: string, --all (-a), --open (-o)] {
  (page $label --all=$all --open=$open) | each {|p| cat ([ $p url.txt ] | path join) } }

def "page body" [label?: string, --all (-a), --open (-o)] {
  (page $label --all=$all --open=$open) | each {|p| cat ([ $p body.html ] | path join) } }

def "page close" [label?: string, --all (-a), --open (-o)] {
  (page $label --all=$all --open=$open) | each {|p|
    echo remove | save -a ([ $p control ] | path join)
} }

def "page dump" [ --open (-o) ] {
  let c = clock

  let addrs = (ls ~/tabfs/fs/mnt/tabs/by-id/*).name | each {|page|
    let summary = {
      key: ($page | path basename),
      group: ([ $page window] | path join | path expand | path basename),
    }
    [ url title ] | reduce -f $summary {|shape, s|
      $s | merge ({ $shape: ( cat ([ $page $"($shape).txt" ] | path join) ) })
    }
  }

  $addrs | save ($"~/page/addr/($c).pages.dump.json" | path expand)
  $addrs | save ($"~/page/addr/($c).pages.dump.yaml" | path expand)
  if $open { hx $"~/page/addr/($c).pages.dump.yaml" }
}

def "pages" [] {
  let pages = glob "~/tabfs/fs/mnt/tabs/by-id/*/url.txt"
  $pages | each { {n: ($in | path dirname), addr: (cat $in)}}
}

def "page click each" [page: string, label: string] {
  cd (page $page)
  if not ("evals/links" | path exists) {
    $"window.links = [...document.querySelectorAll\('a'\)].filter\(x => x.text == '($label)'\)" |
    save -f evals/links; sleep 1sec; }
  "window.links[window.links.length - 1].click(); window.links.pop()" |
    save -f evals/click
}

def "page link index" [page: string, label: string, place: path,
  --key: cell-path, # a keyed path of `url parse` used as a record name.
  --dura (-d): duration = 2sec, # page load duración
] {
  mkdir $place
  cd (page $page); try { rm evals/* }
  cycle -d $dura $"
    page click each ($page) ($label)
    sleep 1sec
    page body -o | save -f \(
      [ ($place)
        \(if ($key | is-empty) {
          page addr -o | url parse | get path | str substring 1..-1
        } else { page addr -o | url parse | get ($key) } | into string\)
      ] | path join
    \)
    page close -o
  "
}
