def "pipe" --wrapped [
  --label (-l): string,
  --address (-a)?: path,
  --call (-c)?: path,
# -a, --args <ARGS>
  ...command: string,
] {
  let address = $"file:/encu/pipe/($label).wasm"

  let command = if ( $address | is-empty
  )      { $"zellij pipe --name ($label) -- ($command)" # each pipe already plugged in
  } else {
    if ( $call | is-empty
    )      { $"zellij pipe --plugin ($address) --name ($label) -- ($command)" # plug in, use a pipe by address
    } else { $"zellij pipe --plugin ($address) --plugin-configuration ($call) --name ($label) -- ($command)" # plug in, use a pipe by address and addicional called orders.
    }
  }

# Bidireccional comms
  tail -f $"/encu/log/($label)" | zellij pipe --name ($label) --plugin ($address) | wc -l

}

# Remember! As some pipes become popular,
# people may choose and begin running some as background processes;
# `sources` or `drains`, as a simple plumbing analogy.
# In such cases, zellij should load in pipes preceding any command issuances.

# In all cases, drains and sources should be made clear on screen.

# More choices:
# -n, --name <NAME>
# -a, --args <ARGS>
# -h, --help

# -p, --plugin <PLUGIN>
# none named                                               ? > all running pipes
# named; none seen as running                              ? > launches pipe
# "file:" <> $local_pipe_address <> ".wasm"                ? > launches pipe or uses running
# "https://" <> $domain <> $online_pipe_address <> ".wasm" ? > launches pipe or uses running
