def "wp base" [domain: string] {
  http get --full $domain |
  get headers.response |
  where name == link |
  get value.0 |
  parse '<{link}>; rel={rel}' |
  get link.0
}

def "wp dump shape" [base: string, shape: string, --form (-f): string = yml] {
  let node = [. ($base | url parse | get host) $"($shape).($form)" ] |
    path join | path expand
  mkdir ($node | path dirname)
  try { http get ([ $base wp v2 $shape ] | path join) | save -f $node }
}

let labels = [
 posts pages comments media users
 categories tags taxonomies types statuses
 settings themes search plugins
 block-types blocks block-renderer block-directory/search
]

def "wp dump domain" [source: string] {
  let forms = [ csv json yml ]
  let base = wp base $source
  timeit { $labels | each {|l| $forms | each {|f|
    wp dump shape -f $f $base $l
  } } }
}
