# Rapid changes and rebuilds on core modules
def n [] { scope ~/.build/config/nushell }

def s [--rebuild (-r), --upgrade (-u)] {
  if $upgrade { cd ~/.build/nixos; nix flake update };
  if not $rebuild { scope ~/.build/nixos };
  sudo nixos-rebuild switch
  h -r
}

def h [--rebuild (-r)] {
  if not $rebuild { scope ~/.build/nixos };
  home-manager switch --flake $"($env.HOME)/.build/nixos#(whoami)"
  try { hyprctl reload }
}

source ./screen.nu
def sb [] { screen blink 1sec all; }
