source ./nix.nu

# code handles; mnemonic helpers.
def "code apply" [ ...nodes ] { code add -p ...($nodes) }
def "code screen" [] { clear; pwd; echo; ls; echo; git s; }

# a quick codebase explorer
def "code display" [] { code cat-file -p ...(
  code cat-file -p main^{tree} | sk | split column -r '[ \t]+' |
  rename permission shape hash name | get hash
) | less }

def "code lines" [node?: path = "."] {
  nsh cloc cloc --json $node |
    from json |
    reject header |
    transpose lang nums |
    each { merge { ...($in.nums) } } |
    reject nums
}

# def "code log" [] {
#   git log --pretty=oneline --all | lines | each {|l| {
#     hash: ($l | str substring 0..40),
#     summary: ($l | str substring 41..-1),
#   } } | rename hash summary
# }
# def "code log" [] { clear; pwd; echo; code lg; echo; ls; echo; git s; }

# based on: https://www.nushell.sh/cookbook/parsing_git_log.html
def "code log" --wrapped [...call] {
  git log --pretty=%h»¦«%s»¦«%aN»¦«%aE»¦«%aD ...$call |
    lines |
    split column "»¦«" commit subject name email date |
    upsert date {|d| $d.date | into datetime}
}

def "code ls" --wrapped [...call] { code s ...$call | detect columns -n | rename label node }
def "c ls" --wrapped [...call] { code ls ...$call }
def "code changed" --wrapped [...call] { code ls ...$call | where label =~ M | get node }
def cone [addr: path = .] {
  nsh soft-serve soft browse (glob ([$addr *] | path join) | path basename | choose) }

def "code" --wrapped [...call: string] { git ...$call }
alias c = code

alias cap = code apply
alias clog = code log
alias clean = code screen
alias clay = code display
