source ./nix.nu
source ./grammar.nu

# [upgrade] in an homage to `make`,
# check modified signal on each diagram and source,
# and only compile changed sources.

def --env "diagram base" [place: string, ...labels: string] {
  mkdir ([share $place] | path join | path dirname)
  try { rm ([ $place _.d2 ] | path join) }
  $labels |
    replace ($labels | is-empty) {
    glob ([$place *.d2 ] | path join) | path parse | get stem }
}

def "diagram preprocess md" [place: string, ...labels: string] {
  let l = diagram base $place ...($labels)
  $l | each {|name|
    let mds = glob ([$place $name *.md ] | path join | into glob)
    $mds | each {|md|
      let p = $md | path parse
$"shape: page
($p.stem): |md
(cat $md | str replace -a '|' '-')
|" | save -f ([$p.parent $"_($p.stem).d2"] | path join)
    }
  }
}

def "diagram" [place: string, ...labels: string] {
  let l = diagram base $place ...($labels)
  diagram preprocess md $place ...$labels

  $l | each {|name|
    let source = $"($place)/($name).d2"
    let channel = ([$place _.d2] | path join)
    let done = [share $place $"($name).svg"] | path join

    if ((ls $done).modified < (ls $source).modified) {
      diagram prelude | save -f $channel
      open $source | save -a $channel
      nsh d2 d2 -l elk -t 8 $channel $done | print
    }
    $done
  } |
  str join "\n" |
  tee { try { rm ([$place _.d2 ] | path join) } }
}

def "diagram prelude" [] { '
# --------------------
style.fill: "transparent"

classes: {
  done: {
    style: {
      fill: MediumAquamarine;
      stroke-width: 4;
    }
  }

  progress: {
    style: {
      fill: orange;
      stroke-width: 4;
    }
  }

  aim: {
    style: {
      fill: pink
      shadow: true
    }
  }

  deploy: {
    shape: step
    style.fill: cyan
  }

  long: {
    style.fill: gold
  }

  broken: {
    shape: step
    style.fill: red
  }

  ready: {
    style: {
      stroke: green;
      stroke-width: 8
    }
  }

  bridge: {
    style: {
      stroke: purple
      stroke-width: 4
    }
  }
}

style.fill: "transparent";
(* -> *)[*]: { class: bridge }
' }
