source ./nix.nu
source ./grammar.nu

# replace `disc` -> `card`; more generic on modern memory.

def --env d [ --bind (-b), ...names: string ] {
  if $bind { disc bind ...$names };
  let nodes = $names | each { |name| disc ls | where name =~ $name } | flatten
  cd $nodes.0.bind
  $nodes
}

def --env "d b" [] {
  d -b (disc choose)
}

def "disc choose" [] {
  ((glob /dev/sd*) ++ (glob /dev/nvme0n*)) | path basename | choose
}

def "disc chamber" [] { nsh gparted sudo -E gparted }

# def disc [] { nix-shell -p diskonaut --command diskonaut; }

def "disc block" [] {
  nix-shell -p xorg.xhost --command 'xhost +'
  nix-shell -p gparted --command 'sudo gparted'; }

def "disc ls" []  {
  findmnt --list | lines | split column -r " +" | reject 0 |
  rename bind source scheme mode | reject mode |
  insert name { $in.bind | path basename }
}
# { (ls /dev/sd*) ++ (ls /dev/nvme*); }

# launch discs memory card imager.
def "disc image" [] {
  nix-shell -p xorg.xhost --command 'xhost +'
  nix-shell -p rpi-imager --command 'sudo rpi-imager'; }

def "disc place" [label: string] { $"($env.HOME)/disc/(basename $label)" }
def "disc bind" [ ...labels: string ] {
  $labels | exclude {|l| $l in (disc ls).name } |
    each { mkdir (disc place $in); sudo mount $"/dev/(basename $in)" (disc place $in) }

  $labels | each {|l| disc ls | where bind == (disc place $l) } | flatten
}

def "disc chec" [label?: string] { findmnt | lines }

alias "disc space" = disc size
def "disc size" [label?: string] {
  df | lines | split column --regex ' +' | headers
  | rename --column { Mounted: bind, Filesystem: label, Used: used, 1K-blocks: size, Available: open }
  | update cells -c [used open size] { 1024 * ($in | into int) | into filesize }
  | select bind label used open size
  | replace ($label | is-not-empty) { $in | choose-by bind $label }
}

def serial [] {
  print "Here are your discs:"; ls ~/disc | print
  print "recognizable plugged-in media:"; lsblk | print; print ''
  print "recognizable serial channels:"; lsusb | print; print ''
}

def "disc scan" [
  --dura (-d): duration = 8sec
] { loop { clear
  disc space | print
  sleep $dura
} }

def "disc slice" [label: string, slices: int] {
  let node = [ / dev $label ] | path join
  nsh parted sudo parted $node mklabel gpt
  1..$slices | each {
    let begin = ($in - 1) * (100 / $slices) | into int
    let end = ($in) * (100 / $slices) | into int
    nsh parted sudo parted $node mkpart zfs $"($begin)%" $"($end)%"
  }
  nsh parted sudo parted $node print
}

def "disc glob" [...labels: string] {
  $labels | each { (glob $"/dev/($in)") } | flatten
}

source ./disc/zfs.nu
source ./disc/luks.nu
