

# Prepare LUKS-encrypcion scheme on a disc.
def "disc luks prepare" [
  disc: string,
  name: string,
] {
  let source = [ /dev $disc ] | path join
  let label  = $"vg-($name)"

  nsh cryptsetup sudo cryptsetup luksFormat $source
  nsh cryptsetup sudo cryptsetup open $source $name
  sudo pvcreate ([/dev/mapper $name]|path join)
  sudo vgcreate $label ([/dev/mapper $name]|path join)
  sudo lvcreate -l 100%FREE -n $name $label
  sudo mkfs.ext4 -L $name ([/dev $label $name]|path join)
  nsh cryptsetup sudo cryptsetup luksDump $source

  disc luks open $disc $name
}

def "disc luks open" [
  disc: string,
  label: string,
] {
  let source  = [ /dev $disc                 ] | path join | path expand
  let mediary = [ /dev $"vg-($label)" $label ] | path join | path expand
  let mapped  = [ /dev/mapper $label         ] | path join | path expand
  let place   = [ ~/disc $label              ] | path join | path expand

  if not ($mediary | path exists) {
    nsh cryptsetup sudo cryptsetup open $source $label | print
    print "6 second loading period"; sleep 6sec
  }

  if not ($place | path exists) { mkdir $place }
  [ opening $mapped "->" $place] | str join " " | print
  sudo mount $mapped $place
}

## miscellaneous recipes:

# nsh cryptsetup sudo cryptsetup luksOpen $source
# sleep 2sec

# nsh cryptsetup sudo cryptsetup luksFormat /dev/sdb2
# nsh cryptsetup sudo cryptsetup luksOpen /dev/sdb1

# ls
# ls /dev/vg-rec/
# ls /dev/vg-rec/rec/
# mkdir ~/disc/rec
# sudo mount /dev/vg-rec/rec rec
