def esc [] { exit }
def end [] { poweroff }
def br [] { seq 1 (term size).columns | each {'-'} | str join '' | print }

def "nu run" --wrapped [--sources (-s): list<string> = [], ...call: string] {
  let preamble = $sources | each { $"source ~/.config/nushell/($in).nu;" }
  nu -c ($preamble ++ $call | str join " ")
}

def choose [aim?: string] {
  let source = $in
  if ($source | describe) == 'string' { $source | sk
  } else if ($source | length) == 1 { $source.0
  } else if ($aim in $source) { [ $aim ]
  } else if ($aim | is-not-empty) { $source | where { $in =~ $aim }
  } else { $source | str join "\n" | sk }
}

def "choose-by" [label: cell-path, aim?: string] {
  let source = $in
  if ($source | describe | str starts-with 'table<') {
    let choice = $source | get $label | choose $aim
    $source | where { ($in | get $label) in $choice }
} }

def "place prepare" []: [
  path -> path,
  string -> string,
] {
  mkdir ($in | path expand | path dirname)
  return $in }

def assure [proc: closure]: any -> any {
  if ($in | is-not-empty) { $in } else { do $proc } }

def replace [cond: bool, proc: closure] {
  let proceed = $cond # or (($cond | is-empty) and ($in | is-empty))
  $in | if $proceed { $in | do $proc } else { $in }
}

def do-lines [logic: closure] {
  $in | lines | do $logic | str join "\n"
}

def retry [n: int, p: closure] {
  if $n <= 0 { return (do $p) }
  try { do $p } catch { retry ($n - 1) $p }
};

# `blob` should remind you of `glob`.
# def blob [glob: string] { glob $glob | sort }

def "exclude" [proc: closure]: list<any> -> list<any> {
  $in | where { not (do $proc $in | into bool) }
}
