source './disc.nu'

def "hub place" []: [
  path -> path
  nothing -> path
] {
  # d -b rec-clone; mkdir ~/disc/rec-clone/code # prior
  # disc load card/code; cd ~/card/code
  '~/space/code' | mkcd
  ($in | assure {.}) | path expand
}

  # let base = (
  #   let p = "~/code/rebase.hub" | path expand;
  #   if not ($p | path exists) { bind code code };
  #   $p; )

  # if ($org | is-empty) { $base } else {
  #   [ $base ($org | path basename) ] | path join | path expand
  # }

# code handles; mnemonic helpers.
def "hub base" [ --org (-o): string, --page: number = 1 ] {
  if ($page == 1) { print $org }
  let bases = http get $"https://api.github.com/users/($org)/repos?per_page=100&page=($page)"
  if ($bases | is-empty) { [] } else {
    $bases ++ (hub base -o $org --page ($page + 1))
  } }

def --env "hub rebase" [
  --upgrade (-u),
  ...names: string,
] {
  if ($upgrade and ($names | length) == 0) {
    hub rebase ...((ls (hub place) | where type == 'dir').name | path basename)
    return nil
  }

  let nom = hub clone ...(
    $names | each {|label|
      if ($label | str contains '/') { $label
      } else { (hub base -o $label).full_name
      } | str downcase
    } | flatten)

  if ($nom | length) == 1 { cd ($nom.0 | hub place)}
  $nom
}

def "hub clone" [...bases: string] {
  $bases | where { $in | hub place | path exists }
    | each { cd ($in | hub place); code fetch; code pull; } | print

  $bases | where { not ($in | hub place | path exists) }
    | each {|label|
      let log = $"($label | hub place).(clock | str trim).clone.log" | path expand
      $label | hub place | path dirname | mkcd;
      nsh gitoxide gix clone $"git@github.com:($label | str downcase)" | tee { save -a $log } | print
    }
  $bases | each { $in | hub place }
}

# def "hub issue" [
#   --org (-o): string,
#   --base (-b): string,
#   --number (-n): int,
# ] { http get $"https://api.github.com/repos/($org)/($base)/issues/($number)" }

def "hub issue" [
  org: string,
  base: string,
  number?: int,
] { http get $"https://api.github.com/repos/($org)/($base)/issues/($number)" }

def "hub release" [base: string, ...queries: string] {
  let releases = (http get $"https://api.github.com/repos/($base)/releases/latest").assets
  let choices = $releases | where {|r| $queries | all { $r.name =~ $in } }
  let name = $choices.name | choose
  let choice = $choices | where name == $name
  $choice.browser_download_url.0
}

def "hub release pull" [
  base: string,
  command?: string,
  ...queries: string,
  --run (-r),
  # --machine (-m): record,
] {
  let address = hub release $base ...$queries

  let zip = $address | parse '{main}.zip' | get -o 0
  let tarball = $address | path basename | parse '{main}.tar.{compression}' | get -o 0

  # print $zip
  # print $tarball

  let unpack = if not ($tarball | get -o compression | is-empty) {
    { xz: $" | tar -O -Jxf - ($tarball.main)/($command)"
    } | get $tarball.compression
  } else if not ($zip | is-empty) {
    $"tar -O -xvf - ($zip.main)/($command)"
  } else {''}
  if ($unpack | is-empty) { print "Possible error! Unrecognized blob schema."; print $address; print $tarball; }

  let cmd = $"wget -O - ($address) ($unpack) > /usr/local/bin/($command) && chmod +x /usr/local/bin/($command)"
  if $run { nsh -p [ wget gnutar ] $cmd | print } else { $cmd }
}

def "hub choose" [--org (-o): string] {
  hub base -o $org |
  select full_name description |
  each {$"($in.full_name)\t($in.description)" } |
  choose | split row "\t" | get 0 | hub rebase $in
}

# def "hub release pull" [
#   base: string,
#   ...queries: string,
#   --display (-d),
#   --binary (-b): string,
# ] {
#   let address = hub release $base ...$queries
#   let zip = $address | parse '{main}.zip' | get -o 0
#   let tarball = $address | path basename | parse '{main}.tar.{compression}' | get -o 0

#   let main = if not ($tarball | is-empty) { $tarball.main
#   } else if not ($zip | is-empty) { $zip.main
#   } else { null }

#   let compression = if not ($tarball | is-empty) { $tarball.compression
#   } else if not ($zip | is-empty) { zip
#   } else { null }

#   # let unpack_call = $unpack + if not ($tarball | get -o compression | is-empty) {
#   # ($zip.main)/($command)

#   # let unpack_pipe = if not ($binary | is-empty) { '' } else {
#     # " -O ($tarball.main)/($command) > /usr/local/bin/($binary) && chmod +x /usr/local/bin/($binary)" }

#   let unpack_call =


#    if ($tarball | get -o compression | is-empty) {
#     { xz: $"| tar -Jxf -"
#     } | get $tarball.compression
#   } else if not ($zip | is-empty) {
#     $"| tar -xvf -"
#   } else {''}
#   if ($unpack_call | is-empty) { print "Possible error! Unrecognized blob schema."; print $address; print $tarball; }

#   let cmd = $"wget -O - ($address) ($unpack)"
#   if $display { $cmd } else { ($cmd) }
# }


# "
# let node = mktemp -d
# cd $node
# wget $address
# als ($address | path basename)
# "


# def "drop hx" [ machine: record, --display (-d) ] {
#   hub release drop 'helix-editor/helix' hx "x86_64-linux.tar.xz" -m $machine -d $display
# }

# def "drop miniserve" [machine: record, --display (-d)] {
#   (hub release drop
#     -m $machine
#     -d $display
#     svenstaro/miniserve miniserve
#     x86_64 linux-musl
#   )
# }
