def "nix lxc" [] {
  nix run github:nix-community/nixos-generators -- --format proxmox-lxc
}

# > lxc build 220
def "lxc build" [num: int] {
  cd ~/.build/lxc; mkdir ./img
  let node = $"lxc.($num).config.nix"
  open -r lxc.sample.config.nix | str replace 'LXC#' ($num | into string) | save $node
  let img = nix run github:nix-community/nixos-generators -- --format proxmox-lxc -c $node
  rsync -rv $img ./img/
  print $img
  ls ./img | print
}
