def "machine norm" [ number: int ] { {
  login: root,
  address: $"10.0.0.($number)",
  key: ~/.ssh/id_ed25519.pub,
} }

def "machine cycle" [ machine: record ] { try { shell $machine reboot }; ping $machine.address }

let machines = {
  pebble: { login: nixos, address: "10.0.10.101", name: pebble },

  # baseline: {login: calliope, address: "173.66.32.84", name: baseline, channel: 2200 },

  baseboard: {login: calliope, address: "10.0.10.10", name: baseboard },

  # rebase: {login: root, address: "10.0.0.220", name: rebase },
  # beacon: { login: root, address: "172.233.232.194", name: beacon },

  bio: { login: gatlay, address: "nf.mocomakers.com", name: bio },

# # mobile lab
genkan: { login: admin, address: "10.0.0.1" },
pier: { login: access, address: "10.0.0.201" },

# 201 share.operand.space
hill: { login: root, address: "10.0.0.210" },
prox: { login: root, channel: 21, address: "10.0.0.2" },

# share: { login: root, channel: 21, address: "96.66.46.225" },
# share: {login: root, address: "172.233.194.84", name: base },

# proxy: { login: root, channel: 21, address: "96.66.46.225" },
# mesh: { login: calliope, channel: 22, address: "96.66.46.225" },

press     : (machine norm 2),   # 2 assemble.press
pulse     : (machine norm 121), # pulse.operand.online
paper     : (machine norm 103), # 103 paper.garden
session   : (machine norm 106), # 106 session.place
assembled : (machine norm 202), # 202 assembled.app
backlog   : (machine norm 105), # 105 backlog.space
calcom    : (machine norm 204),
carbon    : (machine norm 194), # 194 silicon.am
deploy    : (machine norm 205), # 205 deploy.guide
gym       : (machine norm 104),
labori    : (machine norm 208), # 208 labori.us
lock      : (machine norm 207), # 207 padlock.space
pico      : (machine norm 200), # 200 picogr.am
pagemark  : (machine norm 202),
pain      : (machine norm 203),
space     : (machine norm 209),

}; let m = $machines

def announce [ message: any,
    -s: record = { size: 1 }, # shape (displayed message)
] {
  print "\n"
# for x in 1..$s.size { print "\n" }

# if (($message | describe) == 'string' ) {
# for x in 1..$s.size { print --no-newline "  " }; }; # print $message } # | lines | each { .... }

  if (($message | describe) == 'table') {
    print ($message | table --expand | into string) }

  # else { print $message }
  print $message
  print "\n"
}

def "machine address" [mach:record] { $"($mach.login)@($mach.address)" }

# let mach = $machines | transpose | find column0 = $m | get column1

let names = $machines | transpose | get column0

def console --wrapped [mach: record, ...command] {
  let chan = if not ($mach | get -o channel | is-empty) { $mach | get channel } else { 22 }
  ssh -t -p ($chan) (machine address $mach) ($command | str join ' ') }

def prox [mach: record, ...command] {
  let chan = if ($mach | transpose | get column0 | find channel | length) > 0 { $mach | get channel } else { 22 }
  console $m.proxy ssh -t -p $chan (machine address $mach) ($command | str join ' ')
}

def shell --wrapped [mach: record, ...command] {
  let chan = if ($mach | transpose | get column0 | find channel | length) > 0 { $mach | get channel } else { 22 }
  ssh -p ($chan) (machine address $mach) ($command | str join ' ') }

def mesh [mach: record] {
  let chan = if ($mach | transpose | get column0 | find channel | length) > 0 { $mach | get channel } else { 22 }
  mosh --ssh=$"ssh -p ($chan)" (machine address $mach) }

# hacdc
def amnesia-sh [] { ssh hacdcadmin@205.196.222.120; } #amnesia.dreamhost.com; }
def wiki-sh [] { ssh -t root@10.11.3.206; }

# # program local domains
def on [address:int]   { ssh -t $"root@10.0.0.($address)"; }

def proxy-cycle []  {
  console $m.proxy ./cycle.sh
  shell $m.proxy systemctl status caddy
  shell $m.proxy journalctl -fu caddy }

def proxy --wrapped [machine: record, ...call] {
  console $m.proxy $"ssh (machine address $machine) ($call | str join ' ')"
}

def assembled-c []     { ssh -t root@10.0.0.202 'dokku run assembled rails c'; }
def assembled-cycle [] { ssh -t root@10.0.0.202 'dokku ps:restart assembled'; }
def assembled-log []   { ssh -t root@10.0.0.202 'dokku logs -t assembled'; }

def pico-cycle [] { cd; bind backup backup;
  let node = $"backup/log/(clock | str trim).picogram.log"
  ssh root@10.0.0.200 'cd /pico && docker compose logs' | save $node;
  ssh root@10.0.0.200 bash /root/cycle.sh }

def lock-cycle [] { cd; bind backup backup;
  let node = $"backup/log/(clock | str trim).padlock.log"
  ssh root@10.0.0.207 'cd /root/passbolt && docker compose logs' | save $node;
  ssh root@10.0.0.207 bash /root/cycle.sh;
}

def "mach kernel" [] { ((uname).kernel-version | split column -r '[ \-]').column2.0 }
