source ./day.nu
source ./disc.nu

def channels [] { echo "needs encoding!" }
def "media psql" [] { '~/space/media' | mkcd
  mpv ...(tree -afix media | rg PostgreSQL16 | rg mkv | lines | sort) }

def --env "media base" [] { '~/space/media' | mkcd; pwd }
  # disc load card/media; '~/card/media/youtube.com' | mkcd

def "media episodes" [name: string] {
  let base = '~/space/media/anime'
  let anime = glob ([$base '*'] | path join | path expand)
    | where { ($in | path basename | str downcase) =~ $name }
    | get 0
  ls $anime | get name | sort
}

def "media episode" [name: string, number: int] {
  let episodes = media episodes $name | where {|e| (
    $e | path basename
    | parse --regex '\bS(?<s>[0-9]+)E(?<e>[0-9]+)'
    | get e.0 | into int
  ) >= $number }
  mpv ...($episodes | tee { print })
}

def --wrapped "media play" [...labels: string] {
  media base
  let all = tree -afix --noreport ~/space/media
  let records = $labels | each {|label|
    $all | rg $label | lines | where { ($in | path parse | get extension) == mkv }
  } | flatten
  mpv ...($records)
}

def "media place" [
  source: string,
  --key (-k): cell-path = path,
] { media base; (media label $source -k $key) | path expand }

def "media label" [
  source: string,
  --key (-k): cell-path = $.path,
] {
  $source | url parse | # tee { table -e | print } |
    get host $key | update 1 { str substring 1..-1 } | path join
}

def "media bundle" [
  ...addresses: string,
  --label (-l): string,
  --key (-k): cell-path = $.path,
] {
  '~/space/media' | mkcd
  $addresses |
    each { media label $in -k $key } | str join "\n" |
    save ([ (day) (cloc) $label bundle index ] | str join '.')
  $addresses |
    each { media source $in -k $key} | uniq |
    tee { str join "\n" | save ([ (day) (cloc) $label bundle key index ] | str join '.') }
}

def "media source" [
  ...sources: string,
  --key (-k): cell-path = path,
  --play (-p),
] {
  let response = $sources | each {|source|
    media place $source -k $key | mkcd
    print; print; print "----"
    print $"# [media source] Pulling ($source) -> (pwd)"

    let log = [ (day) (cloc) source log ] | str join '.'
    (nsh yt-dlp yt-dlp
      --break-per-input
      --check-all-formats
      --check-formats
      --embed-thumbnail
      --no-resize-buffer
      --prefer-free-formats
      --live-from-start
      # --yes-playlist
      # --cookies ~/space/media/cookies.txt

      # log all enabled media encodings
      # and capción languages.
      # --list-formats
      # --list-subs
      # --sub-langs all
      # --write-auto-subs

      # slice open media packages,
      # and pull an audio copy.
      --extract-audio
      --keep-video

      --lazy-playlist

      # ensure copies are made using closed capcións
      # include as many languages as possible.
      # [chec] are dubbed audio copies included as an opción?
      --write-pages
      --write-subs

      # log each, and record names and hashes in a cache.
      --download-archive ../arc.log

      # signal dials - message packaging.
      --retries 24
      # --http-chunk-size 8M
      # --buffer-size 16384
      --retry-sleep 12
      # --limit-rate 300M
      # --throttled-rate 128M

      $source
    ) | tee { save -a $log } | tee { print }
  } | str join "\n"

  if $play {
    media play ...($response | media parse)
  }
}

def "media channel" [
  ...channels: string,
  --play (-p),
] {
  let response = $channels
  | each {|channel| media source $"https://youtube.com/@($channel)" }
  | str join "\n"
  # if $play { media play ...($response | media parse) }
  $response
}

def "media parse" [] {
  let dl = $in | lines
    | where { $in =~ '[download]' }
    | each {str replace -r '^\[download\] *' ''}
  ( $dl
    | where { $in =~ 'Destination:' }
    | each { $in | tee { print } | split row ' ' | last | parse '[{label}].{_}' | get label.0 }
  ) ++ ( $dl
    # | where { $in =~ ': has already been recorded in the archive' }
    | each { $in | split row ':' --number 2 | get 0 }
  )
    | flatten | uniq
}

def "media records" [] {
  let all = tree -afix ~/space/media/ | lines
  $in | media parse | each {|l| $all | where { $in =~ $l and $in =~ mkv } } | flatten }
