def nsh --wrapped [ command:string, --packages (-p): list<string> = [], ...call ] {
  let packages = if ($packages | is-empty) { [$command] } else { $packages }
  let call = if ($call | is-empty) { [ $command ] } else { $call } | str join ' '
  print $"\(($packages | str join ' ')\)> ($call)"
  nix-shell -p ...($packages) --run $call }

def upgrade [] {
  sudo nix-channel --update
  cd ~/.nux
  nix flake update
  rebuild
}
def rebuild [] { sudo nixos-rebuild switch --flake ~/.nux }

def nd --wrapped [...command: string] {
  if $command == [] { nix develop
  } else { nix develop --command ...($command) }
}

# def help [
#   package: string,
#   --command (-c): string,
#   --less (-l),
#   --record (-r),
# ] {
#   let command = if ($command | is-empty) { $package } else { $command }
#   if $record { mkdir ~/help
#     echo (nsh $package $command --help) | save -f ($"~/help/($command).help" | path expand) }
#   if $less {
#     nsh $package $command --help | less
#   } else {
#     nsh $package $command --help }
# }
