# qui'cly append a '$' aheado' any d'escpression.
# [ '(' ('$' + $address) ')' ] | str join ' '

# using a record and an access code,
# send in response a proper address
def "place key" [rec: record, access: string] {
  let locale = $access | path dirname
  let name = $access | path basename
  let address = $name | str replace -ra '\(\.(\w+)\)' "(\nsession.$1)"
  let recipe = $address | lines
  let calls = $recipe | last (($recipe | length) - 1) | each {|l| '$' + $l }
  let key = ([$recipe.0] ++ $calls) | str join ''
  $key
}

def "place address" [rec: record, access: string] {
  let key = place key $rec $access
  ('( ' + $"let rec = cat '($rec | to yaml)' | from yaml
      let key = place key $rec '($access)'
      $key
      " + " )")
}

def "place hook" [access: string] {
  place address (place index $access | last) $access }
# # choose a place and unpack an address.
# $"~/rec/session.run.($session.name).($session.clock).rec" | path expand

def "place index" [access: string] {
  (ls ~/rec/session.*.rec).name |
  split column "." |
  select column3 column4 |
  sort-by column4 |
  rename name clock
}

def "place describe" [label?: string] {
  let c = clock | str trim
  let label = if ($label | is-empty) { pwd | path basename } else { $label }

  tree -dafix | save $"($c).($label).dirname.index"

  let nodes = tree -afix | lines | where { path exists } |
  par-each {|n| ls -Dal $n | where type == "file" } | flatten | uniq

  let basenames = $nodes | get name | save $"($c).($label).basename.index"

  $nodes | to csv | save $"($c).($label).node.ls.index.csv"

  let checks = (ls *.index* | where name =~ $"^($c).") | get name |
  par-each { |n| [ ($n) ($n | hash md5) ($n | hash sha256) ] | into record } |
  rename "node" "md5" "sha256"

  let check = $checks | to csv
  let md5 = $check | hash md5
  let sha256 = $check | hash sha256
  let checknode = $"($c).md5-($md5).sha256-($sha256).index.check"

  $check | save $checknode
  $checks | insert 0 { 'node': $checknode, 'md5': $md5, 'sha256': $sha256 }
  $checks
}

def "place glance" [] {
  ls | each { |n| tree -dafix ($n | get name) } |
  str join "\n\n---\n" | lines | less
}
