source ./grammar.nu
source ./nix.nu
source ./disc.nu
source ./gram.nu

source ./hub.nu

def loc [base: path = .] { nsh cloc cloc $base }

def scheme [] {
  let base = [
soaddevgit/waybartheme
sejjy/mechabar
zilero232/arch-install-kit
Prateek7071/dotfiles
woioeow/hyprland-dotfiles
elifouts/Dotfiles
arkboix/sway
kamlendras/waybar-macos-sequoia
sephid86/fulleaf
cjbassi/config
Robinhuett/dotfiles
Egosummiki/dotfiles
mhdzli/dotfiles
mxkrsv/dotfiles-old
DerAnsari/hyprland-dots
Pipshag/dotfiles_nord
DN-debug/waybar-examples
theCode-Breaker/riverwm
lgaboury/Sway-Waybar-Install-Script
mechakotik/dots
OriginCode/dotfiles
anik200/dotfiles
  ] | str join "\n" | sk
  hub rebase $base
  let dir = tree -afFix --noreport | rg \.css | lines | get 0 |
    path dirname | path expand | tee { print }
  try { rm ~/.build/config/waybar };
  ln -s $dir ~/.build/config/waybar
  nsh waybar
}

def ph [
  place?: path = .,
  --eco (-e): record = {},
] {
  cd $place;
  $eco | load-env;
  [5173 4000 4444] | each { channel close $in }
  try { nd iex -S mix phx.server }
  [5173 4000 4444] | each { channel close $in }
}

def "channel close" [number: int] { try {
  kill (netstat -tunlp |
  tail -n+3 |
  from ssv -n |
  where column2 =~ ($number | into string) |
  get column5 | split row '/' |
  get 0 | into int)
} }

def op [] { ph ~/share/gram/op; }
def book [] { ph ~/space/code/livebook-dev/livebook -e { LIVEBOOK_PORT: 4444 }; }

def panel [] { firefox 'about:debugging#/runtime/this-firefox' }

def hax [] { ansi strip | hx }

def droid [] { nsh android-file-transfer sudo -E android-file-transfer }

def --wrapped ledge [...call] { nsh hledger hledger ...($call) }
def "ledge page" [] { nsh hledger-web hledger-web --allow=edit }

def muse --wrapped [ ...call ] {
  nsh spotify-player $"spotify_player ($call | str join ' ')"; }

def elementary [program: string] {
  nsh $"pantheon.elementary-($program)" $"io.elementary.($program)" }

def pad [name:string] { (padloc $name).0.passcode }
def padloc [ name?: string] {
  let node = "~/padloc.csv" | path expand
  if ($name | is-empty) { hx $node; return }
  cat $node | from csv --flexible -s ',' -q '"' -c '#' --trim all | each {
    let r = values | each { str trim | str replace -r '^"' '' | str replace -r '"$' '' }
    { name: $r.0, domain: $r.1, login: $r.2, passcode: $r.3 }
  } | where domain =~ $name
}

def --wrapped pass [...command: string] {
  nsh go-passbolt-cli $"passbolt ($command | str join ' ')"
}

def ex --wrapped [...call] { nsh exercism exercism ...$call }
def --env "ex up" [lang: string] {
  ([ ~ base code exercise $lang ] | path join | path expand) | mkcd
  cd ((ls | sort-by modified).name | path basename | choose) }

def "mag open" [] { '~/space/media/magnesis' | mkcd
  nsh transmission_4-gtk transmission-gtk }
def "mag super" [] { '~/space/media/magnesis' | mkcd
  nsh transmission_4-gtk sudo -E transmission-gtk }
def mag [mag:string] { '~/space/media/magnesis' | mkcd
  nsh transmission_4 transmission-cli -u 0 -w (pwd) $mag }

def render [glob: string, --shape (-s): string = html] {
  xdg-open ...(glob $glob | each { |node|
    let n = $node | path parse;
    let rend = [ $n.parent render $"($n.stem).($shape)" ] | path join
    let pkg = if ($shape == pdf) {[pandoc texliveSmall]} else {[pandoc]}
    let source = if ($n.extension == md) { 'markdown' } else { $n.extension }
    mkdir ($rend | path dirname)
    try { nsh -p $pkg $"pandoc -f ($source) -t ($shape) ($node) -o ($rend)" | tee { print } }
    $rend
}) }
