# Rapid changes and rebuilds on core modules
def n [] { scope ~/.config/nushell }

def x [--rebuild (-r), --upgrade (-u)] {
  if $upgrade { cd ~/.nux; nix flake update };
  if not $rebuild { scope ~/.nux };
  sudo nixos-rebuild switch
  h -r
}

def h [--rebuild (-r)] {
  if not $rebuild { scope ~/.nux };
  home-manager switch --flake $"($env.HOME)/.nux#(whoami)"
  try { hyprctl reload }
}

source ./screen.nu
def sb [] { screen blink 1sec all; }
