def scan [
  node: path,
  --dura (-d): duration = 8sec
] { loop { clear
  try { ls $node | get name | sort | path basename | print }
sleep $dura } }

def "ip scan" [
  --dura (-d): duration = 8sec
] { cycle ip --brief a }

def "ps scan" [
  name:string,
  --dura (-d): duration = 8sec,
] { loop { clear
  netstat -tunlp | tail -n+3 | lines | split column -r ' +' | where column7 =~ $"/($name)" | print;
  print " "; ps | where name =~ $name | to yaml
sleep $dura } }

def "cycle" --wrapped [ --dura (-d): duration = 6sec, ...command: string ] {
  loop {
    clear | print;
    nu -e (($command | str join ' ') + ' | print; exit' | str join ' ') | print;
    sleep $dura
  }
}
