# manage screens
source ./disc.nu

def screen --wrapped [...call: string] { Hyprland ...($call) }
def "screen shine" [shine:int] { light -S $shine }

def "screen color" [degree?: int] {
  try { nix-shell -p killall --command "killall wlsunset" } # &> /dev/null
  if ($degree != null) { wlsunset -t $degree -T ($degree + 1) } }
def sc [degree: int] { screen color $degree }

def screens [] {
  hyprctl monitors | rg '^Monitor ' | lines | each {|l|
    $l | split column ' ' | get 0 | get column2 }
}

def "screen on" [display?:string] {
  let display = if ($display == null) { screens | choose } else { $display }
  if ($display == "all") { screens | par-each {|s|
    hyprctl dispatch dpms on $s; }
  } else { hyprctl dispatch dpms on $display; }
}

def "screen off" [display?:string] {
  let display = if ($display == null) { screens | choose } else { $display }
  if ($display == "all") { screens | par-each {|s|
    hyprctl dispatch dpms off $s; }
  } else { hyprctl dispatch dpms off $display; }
}

def "screen blink" [dura:duration, display?:string] {
  let display = if ($display == null) { screens | choose } else { $display }
  if ($display == "all") { screens | par-each {|s| screen blink $dura $s }
  } else { screen off $display; sleep $dura; screen on $display; }
}

def "screen res" [scale?:number] {
  let scale = if ($scale | is-empty) { 1 } else { $scale }

  hyprctl monitors | split row "\n\n" | each {|d|
    let display = $d | lines | split column ":"
    let name = $display | get 0 | get column1
    let res = $display | where {|param| $param.column1 =~ 'availableModes' } |
    get column2 | split column " " | transpose | get column1 |
    where {|d| not ($d | is-empty) } | split column --regex '[x@]' |
    rename x y freq | sort-by --natural --reverse x | get 0

    $res | upsert name $name
    | upsert x (($res | get x | into int) / $scale)
    | upsert y (($res | get y | into int) / $scale)
  }
}

def "screen send" [num?:number] {
  let num = if $num == null {
    hyprctl activeworkspace | rg '^workspace ID' |
    split column ' ' | get column3 | get 0
  } else { $num }
  let screen = screens | choose;
  hyprctl dispatch moveworkspacetomonitor $num $screen;
  hyprctl dispatch focusmonitor $screen;
  hyprctl dispatch forcerendererreload; };

def "screen change" [] {
  hyprctl dispatch swapactiveworkspaces (screens | choose) (screens | choose)
}

# def "screen rec" [] {
#   let node = [ ($env.HOME), "space", "rec",
#   $"(clock | str trim).screen.wf-recorder.mkv" ] | path expand | last
# # echo ([
#   nsh wf-recorder ([
#     "wf-recorder"
#     "-d DP-2" # (screen choose)
#     "--audio='USB Composite Device Pro'"
#     "-c libx264"
#     $"--file=($node)"
#   ] | str join ' ')
# }

# possible: [ auto, avc, hevc, vp8, vp9, av1]
def "screen record" [
  --codec (-c): string = "hevc"
] {
  # [ signal-desktop whatsapp-for-linux webcord ] | each {|gram| ps | where name =~ $gram | each {|p| kill $p} }
  let screen = (screens | choose)
  let c = clock | str trim | split row 'T'
  '~/space/rec' | mkcd
  let node = $"screen.(day).(cloc).($screen).mkv" | path expand
  nsh wl-screenrec wl-screenrec -o $screen --filename $node
    # --codec $codec
    # "--audio --audio-device 'USB Composite Device Pro'"
  $node }
