# https://www.linode.com/docs/guides/install-nixos-on-linode/
{ pkgs, ... }:
{
  boot.loader.timeout = 10;
  boot.kernelParams = [ "console=ttyS0,19200n8" ];
  boot.loader.grub = {
    forceInstall = true;
    device = "nodev";
    extraConfig = ''
      serial --speed=19200 --unit=0 --word=8 --parity=no --stop=1;
      terminal_input serial;
      terminal_output serial;
    '';
  };
  environment.systemPackages = with pkgs; [
   inetutils mtr sysstat ];
}
