{ pkgs, edge, ... }:

{
  # imports = [ <nixpkgs/nixos/modules/virtualisation/lxc-container.nix> ];
  # systemd.suppressedSystemUnits = [ # Supress systemd units that don't work because of LXC
    # "dev-mqueue.mount" "sys-kernel-debug.mount" "sys-fs-fuse-connections.mount" ];
  system.stateVersion = "24.05";

  imports = [ ./hardware-configuration.nix ];

  # networking = {
    # defaultGateway = { address = "10.0.0.1"; interface = "eth0"; };
    # interfaces = { eth0.ipv4.addresses = [{ address = "10.0.0.200"; prefixLength = 24; }]; };
    # nameservers = [ "1.1.1.1" ];
  # };

  networking.firewall = { enable = true;
    # allowedTCPPorts = [ 25 80 110 143 443 465 587 993 995 8008 ];
  #   # allowedUDPPortRanges = [
  #     # { from = 4000; to = 4007; }
  #     # { from = 8000; to = 8010; }
  #   # ];
  };


  # # start tty0 on serial console
  # systemd.services."getty@tty1" = {
  #   enable = lib.mkForce true;
  #   wantedBy = [ "getty.target" ]; # to start at boot
  #   serviceConfig.Restart = "always"; # restart when session is closed
  # };

  services.openssh = {
    enable = true;
    settings.PasswordAuthentication = false;
    settings.KbdInteractiveAuthentication = false;
    settings.PermitRootLogin = "yes";
  };
  services.postgresql.enable = true;

  environment.systemPackages = with pkgs; [ neovim binutils wget docker-compose atuin postgresql tmux rsync ];
  environment.sessionVariables = { PATH= [ "/root/bin" ]; };

  # virtualisation.docker = { enable = true; daemon.settings = { userland-proxy = false; }; };
  # environment.etc."docker/daemon.json".text = ''{ "userland-proxy": false }'';

  environment.systemPackages = with pkgs; [
    binutils git rsync edge.nushell mosh  neovim wget inetutils mtr sysstat ];

  deployment = { targetPort = 22; targetUser = "root"; };
  services.openssh = { enable = true; settings.PermitRootLogin = "yes"; };

  networking = { nameservers = [ "1.1.1.1" ];
    usePredictableInterfaceNames = false; useDHCP = false;
    # defaultGateway = { address = config.deployment.address; interface = "eth0"; };
    interfaces.eth0.useDHCP = true; # ipv4.addresses = [{ prefixLength = 24; }]; };
    firewall = { enable = true; allowedTCPPorts = [ 22 9090 9091 ]; }; };
}
