{ home-manager, nixos-hardware, nixpkgs, pkgs, edge, ... }@sources:
homeConfigurations:
let lib = nixpkgs.lib; in
lib.nixosSystem {
  specialArgs = sources;

  modules = [

    (import ../../module/login.nix rec {
      user = "node"; command = "Hyprland"; init = { inherit command user; };
    })

    # "${nixos-hardware}/framework/13-inch/11th-gen-intel/default.nix"
    home-manager.nixosModules.default

    ./machine.nix
    ./signal.nix
    ./process.nix

    ({ networking.hostName = "clam"; })
    (import ../../module/user.nix { name = "node"; super = true; })

    ({ home-manager.users.node = homeConfigurations.node.config; })

    # ../../home/record.nix
    ../../mach/base.nix

    (import ../../module/hypr.nix { user = "node"; })
    # ../../module/console.nix
    # ../../module/cosmic.nix
    # ../../module/energy.nix
    # ../../module/language.nix
    # ../../module/upgrade.nix

    # (import ../../module/mesh.nix {
    #   machine = "clam";
    #   mesh = "mesh";
    #   beacons = [ "10.0.10.100" "10.0.10.101" ];
    #   map = {
    #     "10.0.10.100" = [ "173.66.32.84:4242" ];
    #     "10.0.10.101" = [ "173.66.32.84:4243" ];
    #   };
    # })

    # ( import ../../gram/elixir.nix {
    #   base = "op"; name = "op"; domain = "operand.online"; channel = 4000;
    #   user = "node"; codebase = "/home/node/disc/nvme0n1p6/gram/op";
    # })

    # ( import ../../gram/expose.nix {
    #   name = "share"; domain = "share.operand.online"; channel = 2222;
    #   command = ''
    #   ${pkgs.miniserve}/bin/miniserve -p 2222 -H /home/node/gram/share -z -g --header "Access-Control-Allow-Origin: *" --header "Access-Control-Allow-Methods: *" --header "Access-Control-Allow-Headers: *"
    #   '';
    # })
  ];
}
