{ command, channel, name, domain }:
{ pkgs, ... }:
let pkg = pkgs.writeShellScriptBin name command;
in {
  system.userActivationScripts."${name}".text = "${pkg}/bin/${name}";
  networking.firewall.allowedTCPPorts = [ 80 443 ];
  environment.systemPackages = [ pkg ];

  imports = [
    (import ../module/proxy.nix   { inherit name channel domain; })
    (import ../module/process.nix { inherit name channel pkg; })
  ];
}
