{ lib, ... }: {
  systemd.suppressedSystemUnits = [ # Supress some systemd modules in LXC
    "dev-mqueue.mount" "sys-kernel-debug.mount" "sys-fs-fuse-connections.mount" ];
  system.stateVersion = "23.11";
  systemd.services."getty@tty1" = { enable = lib.mkForce true;
    wantedBy = [ "getty.target" ]; serviceConfig.Restart = "always"; };
  services.openssh = { enable = true;
    settings.PasswordAuthentication = false;
    settings.KbdInteractiveAuthentication = false;
    settings.PermitRootLogin = "yes"; };
}
