{name, domain, channel}:
{ edge, ...}:
{
  # imports = [(import ./proxy.nix { inherit channel domain name; })];
  users.users.wiki-js = { isNormalUser = true; shell = edge.nushell; };
  networking.firewall.allowedTCPPorts = [ channel ];

  services.wiki-js = { enable = true; settings = {
      # environmentFile = "/home/calliope/guide.call";
      port = channel;
      db = {
        type = "postgres"; host = "127.0.0.1"; port = "5432";
        user = "postgres"; pass = ""; db = name;
        # user = "$(DB_USER)"; pass = "$(DB_PASS)";
      };
    };
  };

  services.postgresql.ensureDatabases = [ name ];
}
