{user}:
{ lib, pkgs, edge, ... } @ sources: {
  programs.hyprland.enable = true;
  # systemd.tmpfiles.rules = [ "d /run/user/1000/hypr 1777 root wheel 42d" ];

  # https://github.com/flatpak/xdg-desktop-portal/blob/1.18.1/doc/portals.conf.rst.in
  # xdg.portal.config.common.default = "*";

  # users.users.${user}.extraGroups = [ "video" ];
  programs.light.enable = true;
  # security.pam.loginLimits = [
    # { domain = "@users"; item = "rtprio"; type = "-"; value = 1; }
  # ];

  # # hyprland on nvidia graphics
  environment.sessionVariables = {
    WLR_NO_HARDWARE_CURSORS = "1";
    NIXOS_OZONE_WL = "1";
    XDG_SESSION_TYPE = "wayland";
    XCURSOR_SIZE = "48";
    QT_QPA_PLATFORM="wayland;xcb";

    # LIBVA_DRIVER_NAME = "nvidia";
    # GBM_BACKEND = "nvidia-drm";
    # __GLX_VENDOR_LIBRARY_NAME = "nvidia";
    # WLR_DRM_DEVICES = "/dev/dri/card0";
  };

  # xdg.portal = { enable = true; wlr.enable = true; extraPortals = with pkgs; [
    # xdg-desktop-portal-gtk
    # xdg-desktop-portal-hyprland
  # ]; };
}
