{
  address,
  peers ? [ "10.10.0.11" "10.10.0.12" "10.10.0.13" ],
  channels ? { manage = "9333"; bind = 9360 },
}:
{ lib, ... }:
{
  networking.firewall.allowedTCPPorts = [ 9333 9360 ];
  systemd.services."kelp" = {
    enable = true; wantedBy = ["multi-user.target"];
    description = "yummy 'cords synchronized in a simple cadence; based on SeaweedFS.";
    unitConfig = { After = "local-fs.target"; Wants = "local-fs.target"; };
    environment = { PATH = lib.mkForce "/run/current-system/sw/bin/"; };
    serviceConfig = {
      Type = "oneshot"; KillMode = "mixed"; TimeoutSec = 0;
      ExecStart = lib.concatStringsSep " " [
        "/bin/sh"
          "-c '${pkgs.seaweedfs}/bin/weed server"
          "-ip ${address}"
          "-master.port=${channels.manage}"
          "-dir=/eco/pond"
          "-volume.port=${channels.bind}"
          "-master.peers=${lib.concatMapStringsSep "," (address: "${address}:${channels.manage}) peers}'"
      ];
    };
  };
}
