{ machine, mesh, map, beacons}:
{ pkgs, ...}:
{
  environment.systemPackages = [ pkgs.nebula ];
  services.nebula.networks.mesh = {
    enable = true;
    isLighthouse = false;
    lighthouses = beacons;
    settings = {
      cipher = "aes";
      punchy = { punch = true; respond = true; };
    };
    cert = "/etc/nebula/${machine}.${mesh}.crt";
    key = "/etc/nebula/${machine}.${mesh}.key";
    ca = "/etc/nebula/ca.crt";
    staticHostMap = map;
    firewall = {
      outbound = [ { host = "any"; port = "any"; proto = "any"; } ];
      inbound  = [ { host = "any"; port = "any"; proto = "any"; } ];
    };
}; }
