{ config, pkgs, lib, ... }:
{
    # defaultGateway = { address = "10.0.0.1"; interface = "enp3s0"; };
    # interfaces = { enp3s0.ipv4.addresses = [ { address = "10.0.0.195"; prefixLength = 24; } ]; };
  networking.firewall = { enable = false;
    allowedTCPPorts = [ 22 8888 9333 9360 18888 19333 55230 ]; # 5672 15672 15692
  };

  services.openssh.enable = true;
  security.pam.services.gdm.enableGnomeKeyring = true;
  sound.enable = true;
  # hardware.pulseaudio.enable = true;

  services.nebula.networks.mesh = {
    enable = true;
    isLighthouse = false;
    isRelay = true;
    lighthouses = [ "10.10.0.1" ];
    staticHostMap = { "10.10.0.1" = [ "172.233.232.194:4242" ]; };
    cert = "/etc/nebula/mesh-a.crt";
    key = "/etc/nebula/mesh-a.key";
    ca = "/etc/nebula/ca.crt";
    firewall.inbound = [ { host = "any"; port = "any"; proto = "any"; } ];
    firewall.outbound = [ { host = "any"; port = "any"; proto = "any"; } ];
    settings.punchy = { punch = true; punch_back = true; respond = true; };
  };

  # systemd.services."weed@pond" = { enable = true;
  #   description = "SeaweedFS `pond` share synchronizer.";
  #   wantedBy = ["multi-user.target"];
  #   unitConfig = { After = "local-fs.target"; Wants = "local-fs.target"; };
  #   environment.PATH = lib.mkForce "/run/current-system/sw/bin/";
  #   serviceConfig = {
  #     Type = "forking";
  #     KillMode = "mixed";
  #     ExecStart = "/bin/sh -c 'weed server -filer -s3 -ip 10.10.0.11 -master.port=9333 -dir=/eco/pond -volume.port=9360 -master.peers=10.10.0.11:9333,10.10.0.12:9333,10.10.0.13:9333'";
  #     TimeoutSec = 0;
  #   };
  # };
}
