{ inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixos-25.05";
    # legacy.url = "github:nixos/nixpkgs/nixos-24.11";
    edge.url = "github:nixos/nixpkgs/nixos-unstable";

    flake-utils.url = "github:numtide/flake-utils";
    home-manager.url = "github:nix-community/home-manager/release-25.05";
    nixos-hardware.url = "github:nixos/nixos-hardware";

    pool = { url = "/pool"; inputs.nixpkgs.follows = "nixpkgs"; };
  };

  outputs = { self, nixpkgs, home-manager, flake-utils, ...
  }@precursor: let

  # [upgrade] https://ayats.org/blog/no-flake-utils
  arches = flake-utils.lib.eachDefaultSystem (arch: let
    call = precursor // rec {
      pkgs = nixpkgs.legacyPackages.${arch};
      legacy = pkgs; # precursor.legacy.legacyPackages.${arch};
      edge = precursor.edge.legacyPackages.${arch};
      inherit arch;
    };

    in {
      machine = {
        baseboard = (import ./cell/baseboard/index.nix call);
        chesapeake = (import ./cell/chesapeake/index.nix call);
        clam = (import ./cell/clam/index.nix call);
        pebble = (import ./cell/pebble/index.nix call);
      };

      home = {
        node = home-manager.lib.homeManagerConfiguration {
          extraSpecialArgs = call; pkgs = call.pkgs;
          modules = [
            ({ home = { username = "node"; homeDirectory = "/home/node"; }; })
            home/hypr.nix home/hypr/idle.nix home/hypr/lock.nix home/hypr/paper.nix home/hypr/pypr.nix
            home/base.nix
            home/console.nix
            home/essence.nix
            home/graphical.nix
            home/helix.nix
            home/session.nix
          ];
        };

        nixos = home-manager.lib.homeManagerConfiguration {
          extraSpecialArgs = call; pkgs = call.pkgs;
          modules = [
            ({ home = { username = "nixos"; homeDirectory = "/home/nixos"; }; })
            home/essence.nix home/base.nix home/console.nix home/session.nix home/helix.nix
          ];
        };

        calliope = home-manager.lib.homeManagerConfiguration {
          extraSpecialArgs = call; pkgs = call.pkgs;
          modules = [
            ({ home = { username = "calliope"; homeDirectory = "/home/calliope"; }; })
            home/hypr.nix home/hypr/idle.nix home/hypr/lock.nix home/hypr/paper.nix home/hypr/pypr.nix home/hypr/screen.nix
            home/base.nix
            home/console.nix
            home/essence.nix
            home/graphical.nix
            home/helix.nix
            home/muse.nix
            home/session.nix
          ];
        };
      };

    });

  x = "x86_64-linux";
  a = "aarch64-linux";

  in rec {
    # [upgrade] pass in microvm configs ready for `autostart`
    # https://microvm-nix.github.io/microvm.nix/host-options.html#microvmvmsnameautostart
    nixosConfigurations = {
      pebble = arches.machine.${a}.pebble;
      baseboard = arches.machine.${x}.baseboard;
      chesapeake = arches.machine.${x}.chesapeake;
      clam = import arches.machine.${x}.clam homeConfigurations;
    };

    homeConfigurations = {
      node = arches.home.${x}.node;
      nixos = arches.home.${a}.nixos;
      calliope = arches.home.${x}.calliope;
    };

    inherit arches;
    inherit precursor;
  };
}
