{lib, nixpkgs, ... }:
let
  channel = 5678;
  name = "graph";
  domain = "${name}.operand.online";
in {
  imports = [(import ../module/proxy.nix { inherit channel domain name; })];
  networking.firewall.allowedTCPPorts = [ 80 443 channel ];

  services.n8n = {
    enable = true;
    settings.port = channel;
  };

  systemd.services.n8n.environment = {
    N8N_PROTOCOL = "https";
    N8N_HOST = domain;
    N8N_EDITOR_BASE_URL = "https://${domain}";
    VUE_APP_URL_BASE_API = "https://${domain}";
    N8N_DEFAULT_CORS = "TRUE";
    N8N_CORS_ALLOW_ORIGIN = "https://operand.online,http://localhost:4000";
  };
}
