{lib, nixpkgs, ... }:
let
  channel = 3999;
  name = "ledge";
  domain = "${name}.operand.online";
in {
  imports = [(import ../module/proxy.nix { inherit channel domain name; })];
  networking.firewall.allowedTCPPorts = [ 80 443 channel ];

  services.actual = {
    enable = true;
    settings.port = channel;
  };
}
