{ channel, name, domain }:
{ home-manager, pkgs, ... }:
{
  networking.firewall = { enable = true; allowedTCPPorts = [ 22 80 channel ]; };
  # systemd.tmpfiles.rules = [
  #   "d /root/.local 1777 root root 10d"
  #   "d /root/.config 1777 root root 10d"
  # ];

  services.wiki-js = { enable = true; settings = {
    bindIP = "0.0.0.0"; port = channel; offline = false;
    # sslOptions = { auto = false; enabled = false; };
    db = { type = "postgres"; host = "localhost"; settings.port = 5432;
      user = "postgres"; pass = "postgres"; db = name; };
  }; };

  services.postgresql = { enable = true; enableTCPIP = true; settings.port = 5432;
    ensureDatabases = [ name ];
    authentication = pkgs.lib.mkOverride 10 ''
      local all all trust
      host  all all 127.0.0.1/32   trust
      host  all all ::1/128        trust
      ''; };

  services.caddy = { enable = true;
    virtualHosts.${domain}.extraConfig = ''
    reverse_proxy 127.0.0.1:${toString channel}
    log {
      output file /var/lib/caddy/${name}.log {
        roll_size     200MiB
        roll_local_time
        roll_keep     1440
        roll_keep_for 1440d
      }
    }
    '';
  };
}
