{ lib, modulesPath, home-manager, ... } @ inputs : let
pkgs = inputs.nixpkgs.outputs.legacyPackages.x86_64-linux;

addresses = [
  "calliope@assembled.app"
  "calliope@opendemocracy.group"
  "calliope@operand.online"
  "g@assembled.app"
  "bill@assembled.app"
  "commercial@assembled.app"
  "code@assembled.app"
  "domains@assembled.app"
  "mail@assembled.app"
  "mail@hyperdemocracy.us"
  "mail@opendemocracy.group"
  "mail@picogr.am"
];

mailname = address: lib.replaceStrings ["@" "."] ["-" "-"] address;

boxes = [ "INBOX" ]; # "INBOX/Sent" "INBOX/Drafts" "INBOX/Junk" ];
box = "INBOX";

maildir = address: let 
in ''
[accounts.${mailname address}]
root_mailbox = "INBOX"
format = "Maildir"
listing.index_style = "Conversations" # or [plain, threaded, compact]
identity="${address}"
display_name = "${address}"
subscribed_mailboxes = [ ${lib.concatStringsSep " " boxes} ]
mailboxes."${box}" = { path = "/home/calliope/2024-06-18.picogram.backup/mail/${address}", autoload = true }

# mailboxes."INBOX" = { path = "/home/calliope/2024-06-18.picogram.backup/mail/${address}", autoload = true }
# mailboxes."INBOX/Sent" = { path = "/home/calliope/2024-06-18.picogram.backup/mail/${address}", autoload = true }
# mailboxes."INBOX/Drafts" = { path = "/home/calliope/2024-06-18.picogram.backup/mail/${address}", autoload = true }
# mailboxes."INBOX/Junk = { path = "/home/calliope/2024-06-18.picogram.backup/mail/${address}", autoload = true }

]
"/home/calliope/2024-06-18.picogram.backup/mail/${address}"
search_backend = "sqlite3"
'';

basic = ''
[pager]
filter = "COLUMNS=72 /usr/local/bin/pygmentize -l email"
pager_context = 0 # default, optional
sticky_headers = true # default, optional

[notifications]
script = "notify-send"
xbiff_file_path = "path" # for use with xbiff(1)
play_sound = true # default, optional
sound_file = "path" # optional

##shortcuts
[shortcuts.composing]
edit = 'e'

[shortcuts.contact-list]
create_contact = 'c'
edit_contact = 'e'

#Pager defaults

[shortcuts.pager]
scroll_up = 'k'
scroll_down = 'j'
page_up = "PageUp"
page_down = "PageDown"

[composing]
#required for sending e-mail
send_mail = 'msmtp --read-recipients --read-envelope-from'
#send_mail = { hostname = "smtp.example.com", port = 587, auth = { type = "auto", username = "user", password = { type = "command_eval", value = "gpg2 --no-tty -q -d ~/.passwords/user.gpg" } }, security = { type = "STARTTLS" } }
editor_command = 'vim +/^$' # optional, by default $EDITOR is used.

[pgp]
auto_sign = false # always sign sent messages
auto_verify_signatures = true # always verify signatures when reading signed e-mails

[terminal]
theme = "dark" # or "light"
'';

## Set mailbox-specific settings
#  [accounts.account-name.mailboxes]
#  "INBOX" = { rename="Inbox" }
#  "drafts" = { rename="Drafts" }
#  "foobar-devel" = { ignore = true } # don't show notifications for this mailbox

maildirs = lib.concatMapStringsSep "\n" maildir addresses;

in {
  home-manager.users.calliope.home.file.".config/meli/config.toml".text = ''
  ${basic}
  ${"\n\n\n\n\n\n"}
  ${maildirs}
  '';
}
