{ ipv4, ipv6, mesh, node }:
{ options, config, pkgs, lib, ... }:
{
  services.nebula.networks.mesh = {
    enable = true;
    isLighthouse = false;
    lighthouses = [ "10.10.0.1" ];
    staticHostMap = { "10.10.0.1" = ["${ipv4}:4242"]; };
    isRelay = true;
    cert = "/etc/nebula/${mesh}-${node}.crt";
    key = "/etc/nebula/${mesh}-${node}.key";
    ca = "/etc/nebula/${mesh}.sign.crt";
    settings.punchy = { punch = true; punch_back = true; respond = true; };

    # search again; nebula group permission model
    firewall.inbound = [ { host = "any"; port = "any"; proto = "any"; } ];
    firewall.outbound = [ { host = "any"; port = "any"; proto = "any"; } ];
  };
}
