{name, domain, channel, node ? "127.0.0.1", lines ? ""}:
{ services.caddy = { enable = true; dataDir = "/var/lib/caddy";
    virtualHosts.${domain}.extraConfig = ''
    reverse_proxy ${node}:${toString channel}
    log {
      output file /var/lib/caddy/${name}.log {
        roll_size     200MiB
        roll_local_time
        roll_keep     1440
        roll_keep_for 1440d
      }
    }
    ${lines}
    '';
  };
}
