{ lib, pkgs, home-manager, ... }:
{
  networking = {
    defaultGateway = { address = "10.11.3.1"; interface = "eth0"; };
    nameservers = [ "1.1.1.1" ];
    hostName = "wiki-hacdc-org";
    firewall = { enable = true; allowedTCPPorts = [ 22 80 443 3000 ]; };
  };
# home-manager.users.root.programs.nushell.enable = true;
  environment.systemPackages = with pkgs; [
    neovim binutils git rsync nushell ];
  systemd.tmpfiles.rules = [
    "d /root/.local 1777 root root 10d"
      "d /root/.config 1777 root root 10d"
  ];

  services.wiki-js = { enable = true; settings = {
    bindIP = "0.0.0.0"; port = 3000; offline = false;
    sslOptions = { auto = false; enabled = false; };
    db = { type = "postgres"; host = "localhost"; port = 5432;
      user = "postgres"; pass = "postgres"; db = "wiki"; };
  }; };

  services.postgresql = { enable = true; enableTCPIP = true; settings.port = 5432;
    ensureDatabases = [ "wiki" ];
    authentication = pkgs.lib.mkOverride 10 ''
      local all all trust
      host  all all 127.0.0.1/32   trust
      host  all all ::1/128        trust
      ''; };

  services.caddy = {
    enable = true;
    user = "root";
    group = "root";
    dataDir = "/root";
    package = pkgs.callPackage ./package/xcaddy.nix { plugins = [ "github.com/caddy-dns/cloudflare" ]; };

    configFile = let cloudflareKey = "abc123"; in pkgs.writeText "Caddyfile" ''
      check.hacdcserver.org {
        reverse_proxy 127.0.0.1:3000
          tls {
            dns cloudflare ${cloudflareKey}
          }
        log {
          output file /var/lib/caddy/check-hacdcserver-org.log {
            roll_size     200MiB
              roll_local_time
              roll_keep     180
              roll_keep_for 720d
          }
        }
      }

# wiki.hacdcserver.org {
#   reverse_proxy 127.0.0.1:3000
#   tls {
#     dns cloudflare ${cloudflareKey}
#   }
#   log {
#     output file /var/lib/caddy/wiki-hacdcserver-org.log {
#       roll_size     200MiB
#       roll_local_time
#       roll_keep     180
#       roll_keep_for 720d
#     }
#   }
# }

    '';
  };
}
