{ home-manager, nixos-hardware, nixpkgs, pkgs, pool, ... }@sources:
let lib = nixpkgs.lib; in
lib.nixosSystem {
  specialArgs = sources;
  modules = [
    "${nixos-hardware}/framework/13-inch/11th-gen-intel/default.nix"
    home-manager.nixosModules.default

    (import ../../module/login.nix {
      user = "calliope";
      command = ''nu -e "hop home"'';
    })

    ./signal.nix
    ./machine.nix
    ./process.nix

    ({ networking.hostName = "baseboard"; })
    (pool.channel.${sources.arch} "eno1")
    ../../mach/base.nix

    (import ../../module/user.nix { name = "calliope"; super = true; })
    ({ home-manager.backupFileExtension = ".home.backup"; })

    # [pool:drop/op]
    ({ services.caddy = let
        node = "10.0.0.8";
        name = "op";
        domain = "http://operand.online";
        channel = 4000;
      in {
        enable = true;
        dataDir = "/var/lib/caddy";
        globalConfig = ''servers {
           trusted_proxies static private_ranges
        }'';
        virtualHosts.${domain}.extraConfig = ''
        reverse_proxy ${node}:${toString channel}
        log {
          output file /var/lib/caddy/${name}.log {
            roll_size     200MiB
            roll_local_time
            roll_keep     1440
            roll_keep_for 1440d
          }
        }
        '';
      };
    })

    ../../module/essence.nix
    ../../module/psql.nix
    ../../module/relay.nix
    ../../module/zfs.nix

    ( import ../../module/guide.nix {
      name = "guide";
      domain = "guide.operand.online";
      channel = 4004;
    })

    ( import ../../gram/elixir.nix {
      base = "op"; name = "op"; domain = "operand.online"; channel = 4000;
      user = "calliope"; codebase = "/home/calliope/share/gram/op";
    })

    ( import ../../gram/ledge.nix )

    ../../gram/image.nix
    ../../gram/map.nix

    ( import ../../module/process.nix rec {
      name = "share"; channel = 2222;
      pkg = pkgs.writeShellScriptBin name ''
      ${pkgs.miniserve}/bin/miniserve -p ${toString channel} -H /home/calliope/share -z -g
    ''; })

    ( import ../../module/process.nix rec {
      name = "resume"; channel = 2223;
      pkg = pkgs.writeShellScriptBin name ''
      ${pkgs.miniserve}/bin/miniserve -p ${toString channel} -H /home/calliope/resume -z -g
    ''; })

    ( import ../../module/mesh.nix {
      machine = "baseboard";
      mesh = "mesh";
      beacons = [ "10.0.10.100" "10.0.10.101" ];
      map = {
        "10.0.10.100" = [ "173.66.32.84:4242" ];
        "10.0.10.101" = [ "173.66.32.84:4243" ];
      };
    })
  ];
}
